<?php
class tabla
{
    private $datos;
    private $borrar = 'X';
    private $editar = 'O';
    private $borra = true;
    private $edita = true;
    private $sql;
    private $urlBorrar = "";
    private $urlEditar = "";
    private $ocultos = [];
    private $id;


    function __construct($datos, $sql, $campoId = 0, $urlBorrar = "", $urlEditar = "", $ocultos = [], $pintar = false)
    {
        $this->datos = $datos;
        $this->sql = $sql;
        $this->urlBorrar = $urlBorrar;
        $this->urlEditar = $urlEditar;
        $this->ocultos = $ocultos;
        $this->id = $campoId;
        if($pintar == true){
            $this->pintar();
        }
    }


    function pintar($clase = "", $iconoBorrar = 'X', $iconoEditar = 'O', $borra = true, $edita = true)
    {
        $this->borrar = $iconoBorrar;
        $this->editar = $iconoEditar;
        $this->borra = $borra;
        $this->edita = $edita;
        $result = $this->datos->query($this->sql);
        $campos = $result->fetch_fields();

        echo "<table class='{$clase}'>";
        echo "<thead><tr>";
        foreach ($campos as $key => $value) {
            if (!in_array($value->name, $this->ocultos)) {
                echo "<th>";
                echo $value->name;
                echo "</th>";
            }
        }
        if ($this->borra == true) {
            echo "<th>{$this->borrar}</th>";
        }
        if ($this->edita == true) {
            echo "<th>{$this->editar}</th>";
        }
        echo "</tr></thead><tbody>";

        while ($row = $result->fetch_assoc()) {
            echo "<tr>";
            foreach ($row as $key => $value) {
                if (!in_array($key, $this->ocultos)) {
                    echo "<td>{$value}</td>";
                }
            }
            $id = $row[$this->id];

            if ($this->borra == true) {
                echo "<td><a href='{$this->urlBorrar}{$id}'>{$this->borrar}</a></td>";
            }
            if ($this->edita == true) {
                echo "<td><a href='{$this->urlEditar}{$id}'>{$this->editar}</a></td>";
            }
            echo "</tr>";
        }
        echo "</tbody></table>";
    }
}
