<?php
include_once("../if/diasemanamejor/fechas.php");
$mes = date("n");
$year = date("Y");
$dia = date("j");

if (isset($_GET['mes']) && isset($_GET['year'])) {
    $mes = $_GET['mes'];
    $year = $_GET['year'];
}

if (isset($_GET['dia'])) {
    $dia = $_GET['dia'];
}

$diasemana = diasTotales(1, $mes, $year) % 7; // 0 al 6
if ($diasemana == 0) {
    $diasemana = 7;
}
?>
<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>La Agenda</title>
    <link rel="stylesheet" href="style.css">
</head>

<body>

    <header>
        <form action="index.php" method="get">
            <input type="hidden" name="dia" value="1">
            <select name="mes" required>
                <?php
                foreach ($meses as $key => $value) {
                    $selected = "";
                    if ($key + 1 == $mes) {
                        $selected = "selected";
                    }
                    echo "<option {$selected} value='" . $key + 1 . "'>{$value}</option>";
                }
                ?>
            </select>
            <input type="number" name="year" value="<?php echo $year; ?>" required min="<?php echo $year - 2; ?>" max="<?php echo $year + 15; ?>">
            <input type="submit" value="Ver Mes">
            <a href="index.php">HOY</a>
        </form>
    </header>

    <main>
        <table class="greenTable">
            <thead>
                <tr>
                    <th>LUNES</th>
                    <th>MARTES</th>
                    <th>MIERCOLES</th>
                    <th>JUEVES</th>
                    <th>VIERNES</th>
                    <th>SABADO</th>
                    <th>DOMINGO</th>
                </tr>
            </thead>
            <tbody>
                <?php
                $contador = 0;
                echo "<tr>";
                for ($d = 1; $d < $diasemana; $d++) {
                    echo "<td></td>";
                    $contador++;
                }

                for ($d = 1; $d <= $diasMeses[$mes]; $d++) {
                    $estilo = "";
                    if ($d == $dia) {
                        $estilo = " class='diaSenalado' ";
                    }
                    echo "<td {$estilo}><a href='index.php?mes={$mes}&year={$year}&dia={$d}'>{$d}</a></td>";
                    $contador++;
                    if ($contador == 7) {
                        echo "</tr>";
                        echo "<tr>";
                        $contador = 0;
                    }
                }

                for ($d = $contador; $d < 7; $d++) {
                    echo "<td></td>";
                }
                echo "</tr>";
                ?>
            </tbody>
        </table>

        <h1>Agenda <?php echo "{$dia}-{$mes}-{$year}"; ?></h1>
        <div id="agenda">
            <form action="guardar.php" method="post">
                <input type="hidden" name="mes" value="<?php echo $mes; ?>">
                <input type="hidden" name="year" value="<?php echo $year; ?>">
                <input type="hidden" name="dia" value="<?php echo $dia; ?>">
                <textarea name="tarea" required placeholder="Tarea">
                    <?php
                    $fichero = "agenda/{$dia}-{$mes}-{$year}.txt";
                    if (file_exists($fichero)) {
                        $tareas = file_get_contents($fichero);
                        echo $tareas;
                    }
                    ?>
                </textarea>
                <br>
                <input type="submit" value="Guardar Tarea">
            </form>
        </div>


    </main>
</body>

</html>