$(function () {
    prioridades();
    tareas();
});


function prioridades() {
    $.getJSON("includes/prioridades.php", function (data) {
        $.each(data, function (key, val) {
            var o = new Option(val.prioridad, val.id);
            $("#prioridad").append(o);
        });
    });
}


function tareas() {
    $("#listado").html("")
    $("#loader").show();
    let prioridad = $("#prioridad").val();
    if (prioridad == null) {
        prioridad = 1;
    }
    $.getJSON("includes/tareas.php?prioridad=" + prioridad, function (data) {
        $("#loader").hide();
        var lis = "";
        $.each(data, function (key, val) {
            lis += "<li id='tarea_" + val.id + "'><div>" + val.tarea + "</div><div onclick='borrarTarea(" + val.id + ")' >X</div></li>";
        });
        $("#listado").hide();
        $("#listado").html(lis)
        $("#listado").show("slow");
    });
}

function borrarTarea(idTarea) {
    if (confirm("Confirma borrar Tarea") == true) {
        $("#loader").show();
        $.getJSON("includes/borrartareas.php?idtarea=" + idTarea, function (data) {
            $("#tarea_" + idTarea).remove();
            $("#loader").hide("slow");
        });
    }
}

function abrirNueva() {
    $("footer").show("slow");
}


function crearTarea() {
    $("footer").hide();
    $("#loader").show();
    $.post("includes/nuevatarea.php", { tarea: $("#tarea").val(), prioridad: $("#prioridad").val() })
        .done(function (data) {
            if (data.id > 0) {
                $.getJSON("includes/tarea.php?id=" + data.id, function (dataTarea) {                    
                    var li = "";
                    $.each(dataTarea, function (key, val) {
                        li += "<li id='tarea_" + val.id + "'><div>" + val.tarea + "</div><div onclick='borrarTarea(" + val.id + ")' >X</div></li>";
                    });
                    $("#listado").append(li);
                });
            } else {
                alert("Algo ha fallado!!");
            }
            $("#loader").hide();
        });
}