function nuevaLinea() {
    let html = `<tr>
                    <td><button type="button">X</button></td>
                    <td><input type="text" required maxlength="250" placeholder="Concepto" name="Concepto[]" id=""></td>
                    <td><input type="number" required step="0.01"  placeholder="Precio" name="Precio[]" id=""></td>
                    <td><input type="number" required value="0" step="0.01" min="0" placeholder="Descuento" name="Descuento[]" id=""></td>
                    <td><input type="number" required step="0.01" placeholder="Cantidad" name="Cantidad[]" id=""></td>
                    <td><input onblur="nuevaLinea(); calcular();" value="21" min="0" required type="number" required step="0.01" placeholder="Iva" name="Iva[]" id=""></td>
                    <td></td>
                    <td></td>
                    <td></td>
                </tr>`;
    $("#presupuesto").append(html);
    $("#presupuesto tr:last-child td:nth-child(2) input").focus();
    borrarLinea();
    calcular();
}

$(document).ready(function () {
    borrarLinea();
    calcular();
});

function borrarLinea() {
    $('#presupuesto button').on('click', function (evt) {
        $(this).parent().parent().remove();
        totales();
    });
}

function calcular() {
    $('#presupuesto input[type="number"]').on('change', function (evt) {
        var precio = parseFloat($(this).parent().parent()[0].children[2].children[0].value);
        var descuento = parseFloat($(this).parent().parent()[0].children[3].children[0].value);
        var cantidad = parseFloat($(this).parent().parent()[0].children[4].children[0].value);
        var iva = parseFloat($(this).parent().parent()[0].children[5].children[0].value);
        var total = precio * cantidad;
        total -= descuento * total / 100;
        var ivaparcial = total * iva / 100;
        $(this).parent().parent()[0].children[6].innerHTML = total;
        $(this).parent().parent()[0].children[7].innerHTML = ivaparcial;
        $(this).parent().parent()[0].children[8].innerHTML = total + ivaparcial;
    });
    totales();
}

function totales() {
    let TOTAL = 0;
    let IVA = 0;
    $('#presupuesto tr').each(function () {
        $.each(this.cells, function (td) {
            if (td == 6 && $(this).text() != "") {
                TOTAL += parseFloat($(this).text());
            }
            if (td == 7 && $(this).text() != "") {
                IVA += parseFloat($(this).text());
            }
        });
    });
    $("#total").text(TOTAL);
    $("#iva").text(IVA);
    $("#TOTAL").text(TOTAL + IVA);
}
